/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: SercosIII_SlIDN_error.h 70361 2017-08-04 10:58:18Z Maher              $

   Description:
    ............................................................................

    Includes following functions:

*******************************************************************************/
#ifndef __SERCOSIII_SL_IDN_ERROR_H
#define __SERCOSIII_SL_IDN_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// SercosIII Slave IDN error codes
/////////////////////////////////////////////////////////////////////////////////////
//Range 0x1000-0x7FFF is reserved for SVC error mapping
//
// MessageId: TLR_E_SERCOSIII_SL_IDN_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command.
//
#define TLR_E_SERCOSIII_SL_IDN_COMMAND_INVALID ((TLR_RESULT)0xC0850001L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_ALREADY_EXISTS
//
// MessageText:
//
//  IDN already exists.
//
#define TLR_E_SERCOSIII_SL_IDN_ALREADY_EXISTS ((TLR_RESULT)0xC0850004L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_INVALID
//
// MessageText:
//
//  Invalid attribute specified.
//
#define TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_INVALID ((TLR_RESULT)0xC0850005L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_INVALID_MAX_DATA_SIZE_SPECIFIED
//
// MessageText:
//
//  Invalid max data size specified.
//
#define TLR_E_SERCOSIII_SL_IDN_INVALID_MAX_DATA_SIZE_SPECIFIED ((TLR_RESULT)0xC0850006L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_SLAVE_INDEX_INVALID
//
// MessageText:
//
//  Slave index invalid.
//
#define TLR_E_SERCOSIII_SL_IDN_SLAVE_INDEX_INVALID ((TLR_RESULT)0xC0850007L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_UNDEFINED_NOTIFY_ALREADY_IN_USE
//
// MessageText:
//
//  Undefined notify already in use.
//
#define TLR_E_SERCOSIII_SL_IDN_UNDEFINED_NOTIFY_ALREADY_IN_USE ((TLR_RESULT)0xC0850008L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_INVALID_ELEMENT_ID
//
// MessageText:
//
//  Invalid element id.
//
#define TLR_E_SERCOSIII_SL_IDN_INVALID_ELEMENT_ID ((TLR_RESULT)0xC0850009L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_APP_PACKET_RESPONSE_INVALID
//
// MessageText:
//
//  Application's Response Packet invalid.
//
#define TLR_E_SERCOSIII_SL_IDN_APP_PACKET_RESPONSE_INVALID ((TLR_RESULT)0xC085000AL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_APP_TRANSFER_TOO_LONG
//
// MessageText:
//
//  Application's Transfer Data too long.
//
#define TLR_E_SERCOSIII_SL_IDN_APP_TRANSFER_TOO_LONG ((TLR_RESULT)0xC085000BL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_APP_TRANSFER_LENGTH_WRONG
//
// MessageText:
//
//  Application's Transfer Data length is invalid.
//
#define TLR_E_SERCOSIII_SL_IDN_APP_TRANSFER_LENGTH_WRONG ((TLR_RESULT)0xC085000CL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_APP_MTU_TOO_LOW
//
// MessageText:
//
//  Application's MTU is too low.
//
#define TLR_E_SERCOSIII_SL_IDN_APP_MTU_TOO_LOW ((TLR_RESULT)0xC085000DL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_INVALID_DEST_ID
//
// MessageText:
//
//  Invalid DestId.
//
#define TLR_E_SERCOSIII_SL_IDN_INVALID_DEST_ID ((TLR_RESULT)0xC085000EL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_LISTS_CANNOT_HAVE_A_MINIMUM_VALUE
//
// MessageText:
//
//  Lists cannot have a minimum value.
//
#define TLR_E_SERCOSIII_SL_IDN_LISTS_CANNOT_HAVE_A_MINIMUM_VALUE ((TLR_RESULT)0xC085000FL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_LISTS_CANNOT_HAVE_A_MAXIMUM_VALUE
//
// MessageText:
//
//  Lists cannot have a maximum value.
//
#define TLR_E_SERCOSIII_SL_IDN_LISTS_CANNOT_HAVE_A_MAXIMUM_VALUE ((TLR_RESULT)0xC0850010L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NAME_EXCEEDS_ALLOCATED_LENGTH
//
// MessageText:
//
//  Name exceeds allocated length.
//
#define TLR_E_SERCOSIII_SL_IDN_NAME_EXCEEDS_ALLOCATED_LENGTH ((TLR_RESULT)0xC0850011L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_UNIT_EXCEEDS_ALLOCATED_LENGTH
//
// MessageText:
//
//  Unit exceeds allocated length.
//
#define TLR_E_SERCOSIII_SL_IDN_UNIT_EXCEEDS_ALLOCATED_LENGTH ((TLR_RESULT)0xC0850012L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_EXCEEDS_ALLOCATED_LENGTH
//
// MessageText:
//
//  OpData exceeds allocated length.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_EXCEEDS_ALLOCATED_LENGTH ((TLR_RESULT)0xC0850013L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_INVALID_MAX_LIST_LENGTH
//
// MessageText:
//
//  Invalid max list length.
//
#define TLR_E_SERCOSIII_SL_IDN_INVALID_MAX_LIST_LENGTH ((TLR_RESULT)0xC0850014L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_DEFAULT_VALUE_EXCEEDS_ALLOCATED_LENGTH
//
// MessageText:
//
//  Default value exceeds allocated length.
//
#define TLR_E_SERCOSIII_SL_IDN_DEFAULT_VALUE_EXCEEDS_ALLOCATED_LENGTH ((TLR_RESULT)0xC0850015L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_MINIMUM_AND_MAXIMUM_VALUE_MUST_BE_USED_TOGETHER
//
// MessageText:
//
//  Minimum and maximum value must be used together.
//
#define TLR_E_SERCOSIII_SL_IDN_MINIMUM_AND_MAXIMUM_VALUE_MUST_BE_USED_TOGETHER ((TLR_RESULT)0xC0850016L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_USER_APPLICATION_TRANSFER_ERROR
//
// MessageText:
//
//  User application transfer error.
//
#define TLR_E_SERCOSIII_SL_IDN_USER_APPLICATION_TRANSFER_ERROR ((TLR_RESULT)0xC0850017L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_INTERNALLY_HANDLED_IDN
//
// MessageText:
//
//  IDN is internally handled.
//
#define TLR_E_SERCOSIII_SL_IDN_INTERNALLY_HANDLED_IDN ((TLR_RESULT)0xC0850018L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NO_IDN
//
// MessageText:
//
//  IDN not available.
//
#define TLR_E_SERCOSIII_SL_IDN_NO_IDN    ((TLR_RESULT)0xC0851001L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_INVALID_ACCESS_TO_ELEMENT_1
//
// MessageText:
//
//  Invalid access to element 1.
//
#define TLR_E_SERCOSIII_SL_IDN_INVALID_ACCESS_TO_ELEMENT_1 ((TLR_RESULT)0xC0851009L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NO_NAME
//
// MessageText:
//
//  No Name.
//
#define TLR_E_SERCOSIII_SL_IDN_NO_NAME   ((TLR_RESULT)0xC0852001L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NAME_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Name transmision is too short.
//
#define TLR_E_SERCOSIII_SL_IDN_NAME_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0852002L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NAME_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Name transmision is too long.
//
#define TLR_E_SERCOSIII_SL_IDN_NAME_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0852003L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NAME_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Name cannot be changed (read only).
//
#define TLR_E_SERCOSIII_SL_IDN_NAME_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0852004L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NAME_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Name is write protected at this time.
//
#define TLR_E_SERCOSIII_SL_IDN_NAME_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0852005L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NAME_APPLICATION_TIMEOUT
//
// MessageText:
//
//  Application timeout occurs in the slave.
//
#define TLR_E_SERCOSIII_SL_IDN_NAME_APPLICATION_TIMEOUT ((TLR_RESULT)0xC0852016L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Attribute transmision is too short.
//
#define TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0853002L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Attribute transmision is too long.
//
#define TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0853003L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Attribute cannot be changed (read only).
//
#define TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0853004L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Attribute is write protected at this time.
//
#define TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0853005L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_APPLICATION_TIMEOUT
//
// MessageText:
//
//  Application timeout occurs in the slave.
//
#define TLR_E_SERCOSIII_SL_IDN_ATTRIBUTE_APPLICATION_TIMEOUT ((TLR_RESULT)0xC0853016L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NO_UNIT
//
// MessageText:
//
//  No unit.
//
#define TLR_E_SERCOSIII_SL_IDN_NO_UNIT   ((TLR_RESULT)0xC0854001L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_UNIT_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Unit transmision is too short.
//
#define TLR_E_SERCOSIII_SL_IDN_UNIT_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0854002L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_UNIT_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Unit transmision is too long.
//
#define TLR_E_SERCOSIII_SL_IDN_UNIT_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0854003L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_UNIT_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Unit cannot be changed (read only).
//
#define TLR_E_SERCOSIII_SL_IDN_UNIT_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0854004L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_UNIT_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Unit is write protected at this time.
//
#define TLR_E_SERCOSIII_SL_IDN_UNIT_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0854005L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_UNIT_APPLICATION_TIMEOUT
//
// MessageText:
//
//  Application timeout occurs in the slave.
//
#define TLR_E_SERCOSIII_SL_IDN_UNIT_APPLICATION_TIMEOUT ((TLR_RESULT)0xC0854016L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NO_MINIMUM_VALUE
//
// MessageText:
//
//  No minimum value.
//
#define TLR_E_SERCOSIII_SL_IDN_NO_MINIMUM_VALUE ((TLR_RESULT)0xC0855001L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_MINIMUM_VALUE_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Minimum value transmision is too short.
//
#define TLR_E_SERCOSIII_SL_IDN_MINIMUM_VALUE_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0855002L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_MINIMUM_VALUE_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Minimum value transmision is too long.
//
#define TLR_E_SERCOSIII_SL_IDN_MINIMUM_VALUE_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0855003L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_MINIMUM_VALUE_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Minimum value cannot be changed (read only).
//
#define TLR_E_SERCOSIII_SL_IDN_MINIMUM_VALUE_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0855004L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_MINIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Minimum value is write protected at this time.
//
#define TLR_E_SERCOSIII_SL_IDN_MINIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0855005L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_MAINIMUM_VALUE_APPLICATION_TIMEOUT
//
// MessageText:
//
//  Application timeout occurs in the slave.
//
#define TLR_E_SERCOSIII_SL_IDN_MAINIMUM_VALUE_APPLICATION_TIMEOUT ((TLR_RESULT)0xC0855016L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NO_MAXIMUM_VALUE
//
// MessageText:
//
//  No maximum value.
//
#define TLR_E_SERCOSIII_SL_IDN_NO_MAXIMUM_VALUE ((TLR_RESULT)0xC0856001L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_MAXIMUM_VALUE_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Maximum value transmision is too short.
//
#define TLR_E_SERCOSIII_SL_IDN_MAXIMUM_VALUE_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0856002L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_MAXIMUM_VALUE_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Maximum value transmision is too long.
//
#define TLR_E_SERCOSIII_SL_IDN_MAXIMUM_VALUE_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0856003L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_MAXIMUM_VALUE_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Maximum value cannot be changed (read only).
//
#define TLR_E_SERCOSIII_SL_IDN_MAXIMUM_VALUE_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0856004L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_MAXIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Maximum value is write protected at this time.
//
#define TLR_E_SERCOSIII_SL_IDN_MAXIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0856005L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_MAXIMUM_VALUE_APPLICATION_TIMEOUT
//
// MessageText:
//
//  Application timeout occurs in the slave.
//
#define TLR_E_SERCOSIII_SL_IDN_MAXIMUM_VALUE_APPLICATION_TIMEOUT ((TLR_RESULT)0xC0856016L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_TRANSMISSION_IS_TOO_SHORT
//
// MessageText:
//
//  Operation data transmision is too short.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_TRANSMISSION_IS_TOO_SHORT ((TLR_RESULT)0xC0857002L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_TRANSMISSION_IS_TOO_LONG
//
// MessageText:
//
//  Operation data transmision is too long.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_TRANSMISSION_IS_TOO_LONG ((TLR_RESULT)0xC0857003L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_CANNOT_BE_CHANGED
//
// MessageText:
//
//  Operation data cannot be changed (read only).
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_CANNOT_BE_CHANGED ((TLR_RESULT)0xC0857004L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_AT_THIS_TIME
//
// MessageText:
//
//  Operation data is write protected at this time.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_AT_THIS_TIME ((TLR_RESULT)0xC0857005L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_LOWER_THAN_MINIMUM_VALUE
//
// MessageText:
//
//  Operation data is lower than Minimum value.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_LOWER_THAN_MINIMUM_VALUE ((TLR_RESULT)0xC0857006L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_HIGHER_THAN_MAXIMUM_VALUE
//
// MessageText:
//
//  Operation data is higher than Maximum value.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_HIGHER_THAN_MAXIMUM_VALUE ((TLR_RESULT)0xC0857007L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_INVALID
//
// MessageText:
//
//  Invalid operation data.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_INVALID ((TLR_RESULT)0xC0857008L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_BY_PASSWORD
//
// MessageText:
//
//  Operation data is write protected by password.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_BY_PASSWORD ((TLR_RESULT)0xC0857009L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_DUE_CYCLICALLY_CONFIGURED
//
// MessageText:
//
//  Operation data is write protected. It is configured cyclically.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_DUE_CYCLICALLY_CONFIGURED ((TLR_RESULT)0xC085700AL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_INVALID_INDIRECT_ADDRESSING
//
// MessageText:
//
//  Invalid indirect addressing.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_INVALID_INDIRECT_ADDRESSING ((TLR_RESULT)0xC085700BL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_DUE_OTHER_SETTINGS
//
// MessageText:
//
//  Operation data is write protected due other settings.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_DUE_OTHER_SETTINGS ((TLR_RESULT)0xC085700CL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_INVALID_FLOATING_POINT_NUMBER
//
// MessageText:
//
//  Invalid floating point number.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_INVALID_FLOATING_POINT_NUMBER ((TLR_RESULT)0xC085700DL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_AT_PARAMETERIZATION_LEVEL
//
// MessageText:
//
//  Operation data is write protected at parameterization level.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_AT_PARAMETERIZATION_LEVEL ((TLR_RESULT)0xC085700EL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_AT_OPERATION_LEVEL
//
// MessageText:
//
//  Operation data is write protected at operation level.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_IS_WRITE_PROTECTED_AT_OPERATION_LEVEL ((TLR_RESULT)0xC085700FL)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_PROCEDURE_COMMAND_ALREADY_ACTIVE
//
// MessageText:
//
//  Procedure command already active.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_PROCEDURE_COMMAND_ALREADY_ACTIVE ((TLR_RESULT)0xC0857010L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_PROCEDURE_COMMAND_NOT_INTERRUPTIBLE
//
// MessageText:
//
//  Procedure command not interruptible.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_PROCEDURE_COMMAND_NOT_INTERRUPTIBLE ((TLR_RESULT)0xC0857011L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_PROCEDURE_COMMAND_NOT_EXECUTABLE_AT_THIS_TIME
//
// MessageText:
//
//  Procedure Command is not executable at this time (e.g. wrong slave state).
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_PROCEDURE_COMMAND_NOT_EXECUTABLE_AT_THIS_TIME ((TLR_RESULT)0xC0857012L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_PROCEDURE_COMMAND_NOT_EXECUTABLE_INVALID_PARAM
//
// MessageText:
//
//  Procedure Command is not executable due invalid parameters.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_PROCEDURE_COMMAND_NOT_EXECUTABLE_INVALID_PARAM ((TLR_RESULT)0xC0857013L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_LIST_PARAMETER_NOT_EXCEPTED
//
// MessageText:
//
//  The received current length of list parameter does not match to expectation.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_LIST_PARAMETER_NOT_EXCEPTED ((TLR_RESULT)0xC0857014L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_NOT_YET_CREATED_COMPLETELEY
//
// MessageText:
//
//  Operation data is not yet created completely (it takes more time to create the operation data, try it again later ).
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_NOT_YET_CREATED_COMPLETELEY ((TLR_RESULT)0xC0857015L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_OPDATA_APPLICATION_TIMEOUT
//
// MessageText:
//
//  Application timeout occurs in the slave.
//
#define TLR_E_SERCOSIII_SL_IDN_OPDATA_APPLICATION_TIMEOUT ((TLR_RESULT)0xC0857016L)

//
// MessageId: TLR_E_SERCOSIII_SL_IDN_NAME_INVALID_CODING
//
// MessageText:
//
//  IDN name coding is not UTF8 conform.
//
#define TLR_E_SERCOSIII_SL_IDN_NAME_INVALID_CODING ((TLR_RESULT)0xC0857017L)




#endif  //__SERCOSIII_IDN_ERROR_H

